"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
class FunctionHook {
    constructor(fn) {
        this.fn = fn;
    }
    bind(scope, lifecycleHook) {
        const topic = new sns.Topic(scope, 'Topic');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(scope, lifecycleHook);
    }
}
exports.FunctionHook = FunctionHook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWhvb2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsYW1iZGEtaG9vay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxxQ0FBcUMsQ0FBQyxtREFBbUQ7QUFDekYsb0RBQW9ELENBQUMsaUVBQWlFO0FBRXRILDZDQUF5QztBQUN6Qzs7OztHQUlHO0FBQ0gsTUFBYSxZQUFZO0lBQ3JCLFlBQTZCLEVBQW9CO1FBQXBCLE9BQUUsR0FBRixFQUFFLENBQWtCO0lBQ2pELENBQUM7SUFDTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxhQUF5QztRQUNuRSxNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQzVDLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDNUQsT0FBTyxJQUFJLHNCQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxhQUFhLENBQUMsQ0FBQztJQUMzRCxDQUFDO0NBQ0o7QUFSRCxvQ0FRQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGF1dG9zY2FsaW5nIGZyb20gXCIuLi8uLi9hd3MtYXV0b3NjYWxpbmdcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1hdXRvc2NhbGluZydcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCAqIGFzIHNucyBmcm9tIFwiLi4vLi4vYXdzLXNuc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNucydcbmltcG9ydCAqIGFzIHN1YnMgZnJvbSBcIi4uLy4uL2F3cy1zbnMtc3Vic2NyaXB0aW9uc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNucy1zdWJzY3JpcHRpb25zJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBUb3BpY0hvb2sgfSBmcm9tICcuL3RvcGljLWhvb2snO1xuLyoqXG4gKiBVc2UgYSBMYW1iZGEgRnVuY3Rpb24gYXMgYSBob29rIHRhcmdldFxuICpcbiAqIEludGVybmFsbHkgY3JlYXRlcyBhIFRvcGljIHRvIG1ha2UgdGhlIGNvbm5lY3Rpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBGdW5jdGlvbkhvb2sgaW1wbGVtZW50cyBhdXRvc2NhbGluZy5JTGlmZWN5Y2xlSG9va1RhcmdldCB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBmbjogbGFtYmRhLklGdW5jdGlvbikge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0LCBsaWZlY3ljbGVIb29rOiBhdXRvc2NhbGluZy5JTGlmZWN5Y2xlSG9vayk6IGF1dG9zY2FsaW5nLkxpZmVjeWNsZUhvb2tUYXJnZXRDb25maWcge1xuICAgICAgICBjb25zdCB0b3BpYyA9IG5ldyBzbnMuVG9waWMoc2NvcGUsICdUb3BpYycpO1xuICAgICAgICB0b3BpYy5hZGRTdWJzY3JpcHRpb24obmV3IHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uKHRoaXMuZm4pKTtcbiAgICAgICAgcmV0dXJuIG5ldyBUb3BpY0hvb2sodG9waWMpLmJpbmQoc2NvcGUsIGxpZmVjeWNsZUhvb2spO1xuICAgIH1cbn1cbiJdfQ==