"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("../../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class LambdaProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(route) {
        var _a, _b;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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