"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpProxyIntegration = void 0;
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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