"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpIntegrationType = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is a Lambda proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    /**
     * Integration type is an HTTP proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            payloadFormatVersion: (_a = props.payloadFormatVersion) === null || _a === void 0 ? void 0 : _a.version,
        });
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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