import { Construct, Resource } from "../../../core";
import { IApiMapping, IDomainName } from '../common';
import { IHttpApi } from '../http/api';
import { IHttpStage } from './stage';
/**
 * Properties used to create the HttpApiMapping resource
 */
export interface HttpApiMappingProps {
    /**
     * Api mapping key. The path where this stage should be mapped to on the domain
     * @default - undefined for the root path mapping.
     */
    readonly apiMappingKey?: string;
    /**
     * The HttpApi to which this mapping is applied
     */
    readonly api: IHttpApi;
    /**
     * custom domain name of the mapping target
     */
    readonly domainName: IDomainName;
    /**
     * stage for the HttpApiMapping resource
     *
     * @default - the $default stage
     */
    readonly stage?: IHttpStage;
}
/**
 * The attributes used to import existing HttpApiMapping
 */
export interface HttpApiMappingAttributes {
    /**
     * The API mapping ID
     */
    readonly apiMappingId: string;
}
/**
 * Create a new API mapping for API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
export declare class HttpApiMapping extends Resource implements IApiMapping {
    /**
     * import from API ID
     */
    static fromHttpApiMappingAttributes(scope: Construct, id: string, attrs: HttpApiMappingAttributes): IApiMapping;
    /**
     * ID of the API Mapping
     */
    readonly apiMappingId: string;
    /**
     * API Mapping key
     */
    readonly mappingKey?: string;
    constructor(scope: Construct, id: string, props: HttpApiMappingProps);
}
