"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKey = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * An API Gateway ApiKey.
 *
 * An ApiKey can be distributed to API clients that are executing requests
 * for Method resources that require an Api Key.
 */
class ApiKey extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.apiKeyName,
        });
        const resource = new apigateway_generated_1.CfnApiKey(this, 'Resource', {
            customerId: props.customerId,
            description: props.description,
            enabled: props.enabled || true,
            generateDistinctId: props.generateDistinctId,
            name: this.physicalName,
            stageKeys: this.renderStageKeys(props.resources),
            value: props.value,
        });
        this.keyId = resource.ref;
    }
    renderStageKeys(resources) {
        if (!resources) {
            return undefined;
        }
        return resources.map((resource) => {
            const restApi = resource;
            const restApiId = restApi.restApiId;
            const stageName = restApi.deploymentStage.stageName.toString();
            return { restApiId, stageName };
        });
    }
}
exports.ApiKey = ApiKey;
//# sourceMappingURL=data:application/json;base64,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