"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
/**
 * GitHub source code provider
 */
class GitHubSourceCodeProvider {
    constructor(props) {
        this.props = props;
    }
    bind(_app) {
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
/**
 * GitLab source code provider
 */
class GitLabSourceCodeProvider {
    constructor(props) {
        this.props = props;
    }
    bind(_app) {
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
/**
 * CodeCommit source code provider
 */
class CodeCommitSourceCodeProvider {
    constructor(props) {
        this.props = props;
    }
    bind(app) {
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
//# sourceMappingURL=data:application/json;base64,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