"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
/**
 * An Amplify Console domain
 */
class Domain extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.anyValue({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix === undefined ? s.branch.branchName : s.prefix,
        }));
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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