"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FollowMode = void 0;
/**
 * Symlink follow mode.
 * @deprecated see `core.SymlinkFollowMode`
 */
var FollowMode;
(function (FollowMode) {
    /**
     * Never follow symlinks.
     */
    FollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    FollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    FollowMode["EXTERNAL"] = "external";
    // ----------------- TODO::::::::::::::::::::::::::::::::::::::::::::
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    FollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(FollowMode = exports.FollowMode || (exports.FollowMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9sbG93LW1vZGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmb2xsb3ctbW9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7O0dBR0c7QUFDSCxJQUFZLFVBeUJYO0FBekJELFdBQVksVUFBVTtJQUNsQjs7T0FFRztJQUNILDZCQUFlLENBQUE7SUFDZjs7T0FFRztJQUNILCtCQUFpQixDQUFBO0lBQ2pCOztPQUVHO0lBQ0gsbUNBQXFCLENBQUE7SUFDckIscUVBQXFFO0lBQ3JFOzs7Ozs7Ozs7T0FTRztJQUNILDhDQUFnQyxDQUFBO0FBQ3BDLENBQUMsRUF6QlcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUF5QnJCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTeW1saW5rIGZvbGxvdyBtb2RlLlxuICogQGRlcHJlY2F0ZWQgc2VlIGBjb3JlLlN5bWxpbmtGb2xsb3dNb2RlYFxuICovXG5leHBvcnQgZW51bSBGb2xsb3dNb2RlIHtcbiAgICAvKipcbiAgICAgKiBOZXZlciBmb2xsb3cgc3ltbGlua3MuXG4gICAgICovXG4gICAgTkVWRVIgPSAnbmV2ZXInLFxuICAgIC8qKlxuICAgICAqIE1hdGVyaWFsaXplIGFsbCBzeW1saW5rcywgd2hldGhlciB0aGV5IGFyZSBpbnRlcm5hbCBvciBleHRlcm5hbCB0byB0aGUgc291cmNlIGRpcmVjdG9yeS5cbiAgICAgKi9cbiAgICBBTFdBWVMgPSAnYWx3YXlzJyxcbiAgICAvKipcbiAgICAgKiBPbmx5IGZvbGxvd3Mgc3ltbGlua3MgdGhhdCBhcmUgZXh0ZXJuYWwgdG8gdGhlIHNvdXJjZSBkaXJlY3RvcnkuXG4gICAgICovXG4gICAgRVhURVJOQUwgPSAnZXh0ZXJuYWwnLFxuICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tIFRPRE86Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6OlxuICAgIC8qKlxuICAgICAqIEZvcmJpZHMgc291cmNlIGZyb20gaGF2aW5nIGFueSBzeW1saW5rcyBwb2ludGluZyBvdXRzaWRlIG9mIHRoZSBzb3VyY2VcbiAgICAgKiB0cmVlLlxuICAgICAqXG4gICAgICogVGhpcyBpcyB0aGUgc2FmZXN0IG1vZGUgb2Ygb3BlcmF0aW9uIGFzIGl0IGVuc3VyZXMgdGhhdCBjb3B5IG9wZXJhdGlvbnNcbiAgICAgKiB3b24ndCBtYXRlcmlhbGl6ZSBmaWxlcyBmcm9tIHRoZSB1c2VyJ3MgZmlsZSBzeXN0ZW0uIEludGVybmFsIHN5bWxpbmtzIGFyZVxuICAgICAqIG5vdCBmb2xsb3dlZC5cbiAgICAgKlxuICAgICAqIElmIHRoZSBjb3B5IG9wZXJhdGlvbiBydW5zIGludG8gYW4gZXh0ZXJuYWwgc3ltbGluaywgaXQgd2lsbCBmYWlsLlxuICAgICAqL1xuICAgIEJMT0NLX0VYVEVSTkFMID0gJ2ludGVybmFsLW9ubHknXG59XG4iXX0=