# coding=utf-8

from tweb import base_handler, myweb
from tornado import gen
from webmother.service.async_wrap import ctrl_org
from qccwallet import system_name


class OurPassportsHandler(base_handler.BaseHandler):
    """
    获取我们(组织)的授权列表
    """

    @myweb.authenticated
    @gen.coroutine
    def get(self, oid):
        identity = self.request.headers.get('x-signed-identity')
        access_token = self.request.headers.get('x-access-token')

        array, display = yield ctrl_org.our_passports(oid, system_name, identity, access_token)

        return self.write({'list': array, 'passport_display': display})
