#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scirpy',
 'scirpy.datasets',
 'scirpy.get',
 'scirpy.io',
 'scirpy.io._tracerlib',
 'scirpy.ir_dist',
 'scirpy.pl',
 'scirpy.pp',
 'scirpy.tests',
 'scirpy.tl',
 'scirpy.util',
 'scirpy.util.graph']

package_data = \
{'': ['*'],
 'scirpy.datasets': ['_processing_scripts/*',
                     '_processing_scripts/.ipynb_checkpoints/*',
                     '_processing_scripts/data/*',
                     '_processing_scripts/data/GSM4143655_SAM24345862-lt1/*',
                     '_processing_scripts/data/GSM4143656_SAM24345863-ln1/*',
                     '_processing_scripts/data/GSM4143657_SAM24348188-lt2/*',
                     '_processing_scripts/data/GSM4143658_SAM24348189-ln2/*',
                     '_processing_scripts/data/GSM4143659_SAM24349905-lt3/*',
                     '_processing_scripts/data/GSM4143660_SAM24349906-ln3/*',
                     '_processing_scripts/data/GSM4143661_SAM24353440-lt4/*',
                     '_processing_scripts/data/GSM4143662_SAM24353441-ln4/*',
                     '_processing_scripts/data/GSM4143663_SAM24360809-lt5/*',
                     '_processing_scripts/data/GSM4143664_SAM24360810-ln5/*',
                     '_processing_scripts/data/GSM4143665_SAM24363330-lt6/*',
                     '_processing_scripts/data/GSM4143666_SAM24363329-ln6/*',
                     '_processing_scripts/data/GSM4143667_SAM24363331-lb6/*',
                     '_processing_scripts/data/GSM4143668_SAM24350754-et1/*',
                     '_processing_scripts/data/GSM4143669_SAM24350755-en1/*',
                     '_processing_scripts/data/GSM4143670_SAM24350752-et2/*',
                     '_processing_scripts/data/GSM4143671_SAM24350753-en2/*',
                     '_processing_scripts/data/GSM4143672_SAM24352255-et3/*',
                     '_processing_scripts/data/GSM4143673_SAM24352256-en3/*',
                     '_processing_scripts/data/GSM4143674_SAM24356595-ct1/*',
                     '_processing_scripts/data/GSM4143675_SAM24356596-cn1/*',
                     '_processing_scripts/data/GSM4143676_SAM24358049-ct2/*',
                     '_processing_scripts/data/GSM4143677_SAM24358050-cn2/*',
                     '_processing_scripts/data/GSM4143678_SAM24360638-rt1/*',
                     '_processing_scripts/data/GSM4143679_SAM24360640-rn1/*',
                     '_processing_scripts/data/GSM4143680_SAM24360639-rb1/*',
                     '_processing_scripts/data/GSM4143681_SAM24361563-rt2/*',
                     '_processing_scripts/data/GSM4143682_SAM24361562-rn2/*',
                     '_processing_scripts/data/GSM4143683_SAM24361564-rb2/*',
                     '_processing_scripts/data/GSM4143684_SAM24363036-rt3/*',
                     '_processing_scripts/data/GSM4143685_SAM24363037-rn3/*',
                     '_processing_scripts/data/GSM4143686_SAM24363038-rb3/*',
                     '_processing_scripts/upload/*'],
 'scirpy.tests': ['data/*',
                  'data/10x/*',
                  'data/airr/*',
                  'data/bd/*',
                  'data/bracer/*',
                  'data/test_workflow/*',
                  'data/tracer/*',
                  'data/tracer/SRR10782570/*',
                  'data/tracer/SRR10782570/filtered_TCR_seqs/*',
                  'data/tracer/cell1/*',
                  'data/tracer/cell1/filtered_TCR_seqs/*',
                  'data/tracer/cell2/*',
                  'data/tracer/cell2/filtered_TCR_seqs/*']}

install_requires = \
['anndata>=0.9rc1',
 'awkward>=2.1.0',
 'mudata>=0.2.2',
 'scanpy>=1.9.3',
 'pandas>=1.5,<2',
 'numpy>=1.17.0',
 'scipy',
 'parasail != 1.2.1',
 'scikit-learn',
 'python-levenshtein',
 'python-igraph != 0.10.0,!=0.10.1',
 'networkx>=2.5',
 'squarify',
 'airr>=1.2',
 'tqdm>=4.63',
 'adjustText>=0.7',
 'numba>=0.41.0',
 'pooch>=1.7.0',
 'setuptools_scm',
 'pytoml']

extras_require = \
{':sys_platform == "win32"': ['pycairo>=1.20'],
 'dandelion': ['sc-dandelion>=0.2.3'],
 'diversity': ['scikit-bio>=0.5.7'],
 'doc': ['sphinx>=4.2,<4.3',
         'sphinx-rtd-theme>=0.3.1',
         'scanpydoc[typehints]>=0.7.4',
         'sphinxcontrib-bibtex>=1.0.0',
         'leidenalg',
         'nbsphinx>=0.6.0',
         'jupytext',
         'pycairo',
         'jupyter_client',
         'ipykernel',
         'sc-dandelion',
         'muon>=0.1.3',
         'zarr'],
 'rpack': ['rectangle-packer'],
 'test': ['pytest', 'black', 'pre-commit']}

setup(name='scirpy',
      version='0.13.0rc1',
      description='Python library for single-cell adaptive immune receptor repertoire (AIRR) analysis',
      author='Gregor Sturm, Tamas Szabo',
      author_email=None,
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.8',
     )
