# -*- coding: utf-8 -*-
# Generated by Django 1.11.21 on 2019-06-20 13:10
from __future__ import unicode_literals

import base64

from django.db import migrations


def fill_credential_ids(apps, schema_editor):
    # We need to use historical model
    Authenticator = apps.get_model("django_fido", "Authenticator")
    db_alias = schema_editor.connection.alias
    for authenticator in Authenticator.objects.all():
        authenticator.credential_id_data = base64.b64encode(authenticator.credential.credential_id).decode('utf-8')
        authenticator.save()


class Migration(migrations.Migration):

    dependencies = [
        ('django_fido', '0008_add_credential_id'),
    ]

    operations = [
        migrations.RunPython(fill_credential_ids, reverse_code=migrations.RunPython.noop, elidable=True),
    ]
