#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [ ]

test_requirements = ['pytest>=3', ]

setup(
    author="J. Nick Koston",
    author_email='nick@koston.org',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="A wrapper for aiolifx to connect to a single LIFX device",
    install_requires=requirements,
    license="BSD license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='aiolifx_connection',
    name='aiolifx_connection',
    packages=find_packages(include=['aiolifx_connection', 'aiolifx_connection.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/bdraco/aiolifx_connection',
    version='1.0.0',
    zip_safe=False,
)
