# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class Tag(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, value=None, key=None):
        """Tag - a model defined in OpenAPI

        :param value: The value of this Tag.
        :type value: str
        :param key: The key of this Tag.
        :type key: str
        """
        self.openapi_types = {"value": str, "key": str}

        self.attribute_map = {"value": "value", "key": "key"}

        self._value = value
        self._key = key

    @classmethod
    def from_dict(cls, dikt) -> "Tag":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Tag of this Tag.
        :rtype: Tag
        """
        return util.deserialize_model(dikt, cls)

    @property
    def value(self):
        """Gets the value of this Tag.

        Tag value

        :return: The value of this Tag.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this Tag.

        Tag value

        :param value: The value of this Tag.
        :type value: str
        """

        self._value = value

    @property
    def key(self):
        """Gets the key of this Tag.

        Tag name

        :return: The key of this Tag.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Tag.

        Tag name

        :param key: The key of this Tag.
        :type key: str
        """

        self._key = key
