# Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.metadata import Metadata  # noqa: E501


class Scheduler(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, type=None, metadata=None):  # noqa: E501
        """Scheduler - a model defined in OpenAPI

        :param type: The type of this Scheduler.  # noqa: E501
        :type type: str
        :param metadata: The metadata of this Scheduler.  # noqa: E501
        :type metadata: Metadata
        """
        self.openapi_types = {"type": str, "metadata": Metadata}

        self.attribute_map = {"type": "type", "metadata": "metadata"}

        self._type = type
        self._metadata = metadata

    @classmethod
    def from_dict(cls, dikt) -> "Scheduler":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Scheduler of this Scheduler.  # noqa: E501
        :rtype: Scheduler
        """
        return util.deserialize_model(dikt, cls)

    @property
    def type(self):
        """Gets the type of this Scheduler.


        :return: The type of this Scheduler.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Scheduler.


        :param type: The type of this Scheduler.
        :type type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def metadata(self):
        """Gets the metadata of this Scheduler.


        :return: The metadata of this Scheduler.
        :rtype: Metadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this Scheduler.


        :param metadata: The metadata of this Scheduler.
        :type metadata: Metadata
        """

        self._metadata = metadata
