# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from typing import List

from pcluster.api import util
from pcluster.api.models.ami_info import AmiInfo
from pcluster.api.models.base_model_ import Model


class ListOfficialImagesResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, images=None):
        """ListOfficialImagesResponseContent - a model defined in OpenAPI

        :param images: The images of this ListOfficialImagesResponseContent.
        :type images: List[AmiInfo]
        """
        self.openapi_types = {"images": List[AmiInfo]}

        self.attribute_map = {"images": "images"}

        self._images = images

    @classmethod
    def from_dict(cls, dikt) -> "ListOfficialImagesResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ListOfficialImagesResponseContent of this ListOfficialImagesResponseContent.
        :rtype: ListOfficialImagesResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def images(self):
        """Gets the images of this ListOfficialImagesResponseContent.


        :return: The images of this ListOfficialImagesResponseContent.
        :rtype: List[AmiInfo]
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this ListOfficialImagesResponseContent.


        :param images: The images of this ListOfficialImagesResponseContent.
        :type images: List[AmiInfo]
        """
        if images is None:
            raise ValueError("Invalid value for `images`, must not be `None`")

        self._images = images
