# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.validation_level import ValidationLevel


class ConfigValidationMessage(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, level=None, id=None, type=None, message=None):
        """ConfigValidationMessage - a model defined in OpenAPI

        :param level: The level of this ConfigValidationMessage.
        :type level: ValidationLevel
        :param id: The id of this ConfigValidationMessage.
        :type id: str
        :param type: The type of this ConfigValidationMessage.
        :type type: str
        :param message: The message of this ConfigValidationMessage.
        :type message: str
        """
        self.openapi_types = {"level": ValidationLevel, "id": str, "type": str, "message": str}

        self.attribute_map = {"level": "level", "id": "id", "type": "type", "message": "message"}

        self._level = level
        self._id = id
        self._type = type
        self._message = message

    @classmethod
    def from_dict(cls, dikt) -> "ConfigValidationMessage":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ConfigValidationMessage of this ConfigValidationMessage.
        :rtype: ConfigValidationMessage
        """
        return util.deserialize_model(dikt, cls)

    @property
    def level(self):
        """Gets the level of this ConfigValidationMessage.


        :return: The level of this ConfigValidationMessage.
        :rtype: ValidationLevel
        """
        return self._level

    @level.setter
    def level(self, level):
        """Sets the level of this ConfigValidationMessage.


        :param level: The level of this ConfigValidationMessage.
        :type level: ValidationLevel
        """

        self._level = level

    @property
    def id(self):
        """Gets the id of this ConfigValidationMessage.

        Id of the validator

        :return: The id of this ConfigValidationMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConfigValidationMessage.

        Id of the validator

        :param id: The id of this ConfigValidationMessage.
        :type id: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this ConfigValidationMessage.

        Type of the validator

        :return: The type of this ConfigValidationMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ConfigValidationMessage.

        Type of the validator

        :param type: The type of this ConfigValidationMessage.
        :type type: str
        """

        self._type = type

    @property
    def message(self):
        """Gets the message of this ConfigValidationMessage.

        Validation message

        :return: The message of this ConfigValidationMessage.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ConfigValidationMessage.

        Validation message

        :param message: The message of this ConfigValidationMessage.
        :type message: str
        """

        self._message = message
