# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class AmiInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ami_id=None, os=None, name=None, version=None, architecture=None):
        """AmiInfo - a model defined in OpenAPI

        :param ami_id: The ami_id of this AmiInfo.
        :type ami_id: str
        :param os: The os of this AmiInfo.
        :type os: str
        :param name: The name of this AmiInfo.
        :type name: str
        :param version: The version of this AmiInfo.
        :type version: st
        :param architecture: The architecture of this AmiInfo.
        :type architecture: str
        """
        self.openapi_types = {"ami_id": str, "os": str, "name": str, "version": str, "architecture": str}

        self.attribute_map = {
            "ami_id": "amiId",
            "os": "os",
            "name": "name",
            "version": "version",
            "architecture": "architecture",
        }

        self._ami_id = ami_id
        self._os = os
        self._name = name
        self._version = version
        self._architecture = architecture

    @classmethod
    def from_dict(cls, dikt) -> "AmiInfo":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AmiInfo of this AmiInfo.
        :rtype: AmiInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ami_id(self):
        """Gets the ami_id of this AmiInfo.


        :return: The ami_id of this AmiInfo.
        :rtype: str
        """
        return self._ami_id

    @ami_id.setter
    def ami_id(self, ami_id):
        """Sets the ami_id of this AmiInfo.


        :param ami_id: The ami_id of this AmiInfo.
        :type ami_id: str
        """
        if ami_id is None:
            raise ValueError("Invalid value for `ami_id`, must not be `None`")

        self._ami_id = ami_id

    @property
    def os(self):
        """Gets the os of this AmiInfo.


        :return: The os of this AmiInfo.
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this AmiInfo.


        :param os: The os of this AmiInfo.
        :type os: str
        """
        if os is None:
            raise ValueError("Invalid value for `os`, must not be `None`")

        self._os = os

    @property
    def name(self):
        """Gets the name of this AmiInfo.


        :return: The name of this AmiInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AmiInfo.


        :param name: The name of this AmiInfo.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def version(self):
        """Gets the version of this AmiInfo.


        :return: The version of this AmiInfo.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AmiInfo.


        :param version: The version of this AmiInfo.
        :type version: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def architecture(self):
        """Gets the architecture of this AmiInfo.


        :return: The architecture of this AmiInfo.
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this AmiInfo.


        :param architecture: The architecture of this AmiInfo.
        :type architecture: str
        """
        if architecture is None:
            raise ValueError("Invalid value for `architecture`, must not be `None`")

        self._architecture = architecture
