"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ZLintTypedDict(TypedDict):
    errors_present: NotRequired[bool]
    r"""Whether the certificate's attributes triggered any error lints for non-conformance to the X.509 standard."""
    failed_lints: NotRequired[Nullable[List[str]]]
    r"""A list of lint names which failed, if applicable."""
    fatals_present: NotRequired[bool]
    r"""Whether the certificate's attributes triggered any fatal lints for non-conformance to the X.509 standard."""
    notices_present: NotRequired[bool]
    r"""Whether the certificate's attributes triggered any notice lints for non-conformance to the X.509 standard."""
    timestamp: NotRequired[str]
    r"""An RFC-3339-formated timestamp indicating when the certificate was linted."""
    version: NotRequired[int]
    r"""The version of Zlint used to lint the certificate."""
    warnings_present: NotRequired[bool]
    r"""Whether the certificate's attributes triggered any warning lints for non-conformance to the X.509 standard."""


class ZLint(BaseModel):
    errors_present: Optional[bool] = None
    r"""Whether the certificate's attributes triggered any error lints for non-conformance to the X.509 standard."""

    failed_lints: OptionalNullable[List[str]] = UNSET
    r"""A list of lint names which failed, if applicable."""

    fatals_present: Optional[bool] = None
    r"""Whether the certificate's attributes triggered any fatal lints for non-conformance to the X.509 standard."""

    notices_present: Optional[bool] = None
    r"""Whether the certificate's attributes triggered any notice lints for non-conformance to the X.509 standard."""

    timestamp: Optional[str] = None
    r"""An RFC-3339-formated timestamp indicating when the certificate was linted."""

    version: Optional[int] = None
    r"""The version of Zlint used to lint the certificate."""

    warnings_present: Optional[bool] = None
    r"""Whether the certificate's attributes triggered any warning lints for non-conformance to the X.509 standard."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "errors_present",
            "failed_lints",
            "fatals_present",
            "notices_present",
            "timestamp",
            "version",
            "warnings_present",
        ]
        nullable_fields = ["failed_lints"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
