"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attribute import Attribute, AttributeTypedDict
from .certificate import Certificate, CertificateTypedDict
from .endpointscanstate import EndpointScanState, EndpointScanStateTypedDict
from .jarmscan import JarmScan, JarmScanTypedDict
from .label import Label, LabelTypedDict
from .risk import Risk, RiskTypedDict
from .threat import Threat, ThreatTypedDict
from .tls import TLS, TLSTypedDict
from .vuln import Vuln, VulnTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class WebpropertyTypedDict(TypedDict):
    cert: NotRequired[CertificateTypedDict]
    endpoints: NotRequired[Nullable[List[EndpointScanStateTypedDict]]]
    exposures: NotRequired[Nullable[List[RiskTypedDict]]]
    hardware: NotRequired[Nullable[List[AttributeTypedDict]]]
    hostname: NotRequired[str]
    jarm: NotRequired[JarmScanTypedDict]
    labels: NotRequired[Nullable[List[LabelTypedDict]]]
    misconfigs: NotRequired[Nullable[List[RiskTypedDict]]]
    operating_systems: NotRequired[Nullable[List[AttributeTypedDict]]]
    port: NotRequired[int]
    scan_time: NotRequired[str]
    software: NotRequired[Nullable[List[AttributeTypedDict]]]
    threats: NotRequired[Nullable[List[ThreatTypedDict]]]
    tls: NotRequired[TLSTypedDict]
    vulns: NotRequired[Nullable[List[VulnTypedDict]]]


class Webproperty(BaseModel):
    cert: Optional[Certificate] = None

    endpoints: OptionalNullable[List[EndpointScanState]] = UNSET

    exposures: OptionalNullable[List[Risk]] = UNSET

    hardware: OptionalNullable[List[Attribute]] = UNSET

    hostname: Optional[str] = None

    jarm: Optional[JarmScan] = None

    labels: OptionalNullable[List[Label]] = UNSET

    misconfigs: OptionalNullable[List[Risk]] = UNSET

    operating_systems: OptionalNullable[List[Attribute]] = UNSET

    port: Optional[int] = None

    scan_time: Optional[str] = None

    software: OptionalNullable[List[Attribute]] = UNSET

    threats: OptionalNullable[List[Threat]] = UNSET

    tls: Optional[TLS] = None

    vulns: OptionalNullable[List[Vuln]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cert",
            "endpoints",
            "exposures",
            "hardware",
            "hostname",
            "jarm",
            "labels",
            "misconfigs",
            "operating_systems",
            "port",
            "scan_time",
            "software",
            "threats",
            "tls",
            "vulns",
        ]
        nullable_fields = [
            "endpoints",
            "exposures",
            "hardware",
            "labels",
            "misconfigs",
            "operating_systems",
            "software",
            "threats",
            "vulns",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
