"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cwe import Cwe, CweTypedDict
from .evidence import Evidence, EvidenceTypedDict
from .kev import Kev, KevTypedDict
from .metrics import Metrics, MetricsTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class VulnRiskSource(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    CVE = "cve"


class VulnSeverity(str, Enum):
    UNKNOWN = ""
    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"
    CRITICAL = "critical"


class VulnSource(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    RECOG = "recog"
    WAPPALYZER = "wappalyzer"
    THIRD_PARTY = "third_party"


class VulnTypedDict(TypedDict):
    confidence: NotRequired[float]
    cwes: NotRequired[Nullable[List[CweTypedDict]]]
    evidence: NotRequired[Nullable[List[EvidenceTypedDict]]]
    id: NotRequired[str]
    kev: NotRequired[Nullable[List[KevTypedDict]]]
    metrics: NotRequired[MetricsTypedDict]
    name: NotRequired[str]
    risk_source: NotRequired[VulnRiskSource]
    severity: NotRequired[VulnSeverity]
    source: NotRequired[VulnSource]
    year: NotRequired[int]


class Vuln(BaseModel):
    confidence: Optional[float] = None

    cwes: OptionalNullable[List[Cwe]] = UNSET

    evidence: OptionalNullable[List[Evidence]] = UNSET

    id: Optional[str] = None

    kev: OptionalNullable[List[Kev]] = UNSET

    metrics: Optional[Metrics] = None

    name: Optional[str] = None

    risk_source: Optional[VulnRiskSource] = None

    severity: Optional[VulnSeverity] = None

    source: Optional[VulnSource] = None

    year: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "confidence",
            "cwes",
            "evidence",
            "id",
            "kev",
            "metrics",
            "name",
            "risk_source",
            "severity",
            "source",
            "year",
        ]
        nullable_fields = ["cwes", "evidence", "kev"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
