"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .desktopinfo import DesktopInfo, DesktopInfoTypedDict
from .vnc_keyvalue import VncKeyValue, VncKeyValueTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class VncTypedDict(TypedDict):
    connection_failed_reason: NotRequired[str]
    r"""If server terminates handshake, the reason offered (if any)"""
    desktop_name: NotRequired[str]
    r"""Desktop name provided by the server, capped at 255 bytes"""
    pixel_encoding: NotRequired[VncKeyValueTypedDict]
    screen_info: NotRequired[DesktopInfoTypedDict]
    security_types: NotRequired[Nullable[List[VncKeyValueTypedDict]]]
    r"""server-specified security options"""
    version: NotRequired[str]


class Vnc(BaseModel):
    connection_failed_reason: Optional[str] = None
    r"""If server terminates handshake, the reason offered (if any)"""

    desktop_name: Optional[str] = None
    r"""Desktop name provided by the server, capped at 255 bytes"""

    pixel_encoding: Optional[VncKeyValue] = None

    screen_info: Optional[DesktopInfo] = None

    security_types: OptionalNullable[List[VncKeyValue]] = UNSET
    r"""server-specified security options"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "connection_failed_reason",
            "desktop_name",
            "pixel_encoding",
            "screen_info",
            "security_types",
            "version",
        ]
        nullable_fields = ["security_types"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
