"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopetrackedscan import (
    ResponseEnvelopeTrackedScan,
    ResponseEnvelopeTrackedScanTypedDict,
)
from .scansdiscoveryinputbody import (
    ScansDiscoveryInputBody,
    ScansDiscoveryInputBodyTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3ThreathuntingScansDiscoveryGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3ThreathuntingScansDiscoveryGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3ThreathuntingScansDiscoveryRequestTypedDict(TypedDict):
    scans_discovery_input_body: ScansDiscoveryInputBodyTypedDict
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3ThreathuntingScansDiscoveryRequest(BaseModel):
    scans_discovery_input_body: Annotated[
        ScansDiscoveryInputBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3ThreathuntingScansDiscoveryResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeTrackedScanTypedDict


class V3ThreathuntingScansDiscoveryResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeTrackedScan
