"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopetrackedscan import (
    ResponseEnvelopeTrackedScan,
    ResponseEnvelopeTrackedScanTypedDict,
)
from .scansrescaninputbody import ScansRescanInputBody, ScansRescanInputBodyTypedDict
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GlobaldataScansRescanGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3GlobaldataScansRescanGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3GlobaldataScansRescanRequestTypedDict(TypedDict):
    scans_rescan_input_body: ScansRescanInputBodyTypedDict
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataScansRescanRequest(BaseModel):
    scans_rescan_input_body: Annotated[
        ScansRescanInputBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataScansRescanResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeTrackedScanTypedDict


class V3GlobaldataScansRescanResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeTrackedScan
