"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopetrackedscan import (
    ResponseEnvelopeTrackedScan,
    ResponseEnvelopeTrackedScanTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GlobaldataScansGetGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3GlobaldataScansGetGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3GlobaldataScansGetRequestTypedDict(TypedDict):
    scan_id: str
    r"""The unique identifier of the tracked scan"""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataScansGetRequest(BaseModel):
    scan_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The unique identifier of the tracked scan"""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataScansGetResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeTrackedScanTypedDict


class V3GlobaldataScansGetResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeTrackedScan
