"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopehosttimeline import (
    ResponseEnvelopeHostTimeline,
    ResponseEnvelopeHostTimelineTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from datetime import datetime
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GlobaldataAssetHostTimelineGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3GlobaldataAssetHostTimelineGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3GlobaldataAssetHostTimelineRequestTypedDict(TypedDict):
    host_id: str
    r"""The IP address of a host."""
    start_time: datetime
    r"""Start time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time."""
    end_time: datetime
    r"""End time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time."""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataAssetHostTimelineRequest(BaseModel):
    host_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The IP address of a host."""

    start_time: Annotated[
        datetime, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]
    r"""Start time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time."""

    end_time: Annotated[
        datetime, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]
    r"""End time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time."""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataAssetHostTimelineResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeHostTimelineTypedDict


class V3GlobaldataAssetHostTimelineResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeHostTimeline
