"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopelisthostasset import (
    ResponseEnvelopeListHostAsset,
    ResponseEnvelopeListHostAssetTypedDict,
)
from censys_platform.types import BaseModel, Nullable, UNSET_SENTINEL
from censys_platform.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GlobaldataAssetHostListGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3GlobaldataAssetHostListGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3GlobaldataAssetHostListRequestTypedDict(TypedDict):
    host_ids: Nullable[List[str]]
    r"""A list of host IP addresses."""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataAssetHostListRequest(BaseModel):
    host_ids: Annotated[
        Nullable[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ]
    r"""A list of host IP addresses."""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["organization_id"]
        nullable_fields = ["host_ids"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class V3GlobaldataAssetHostListResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeListHostAssetTypedDict


class V3GlobaldataAssetHostListResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeListHostAsset
