"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopecertificateasset import (
    ResponseEnvelopeCertificateAsset,
    ResponseEnvelopeCertificateAssetTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3GlobaldataAssetCertificateGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3GlobaldataAssetCertificateGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3GlobaldataAssetCertificateRequestTypedDict(TypedDict):
    certificate_id: str
    r"""The SHA-256 certificate fingerprint."""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataAssetCertificateRequest(BaseModel):
    certificate_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The SHA-256 certificate fingerprint."""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""


class V3GlobaldataAssetCertificateResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeCertificateAssetTypedDict


class V3GlobaldataAssetCertificateResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeCertificateAsset
