"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseenvelopecollectioneventsresponse import (
    ResponseEnvelopeCollectionEventsResponse,
    ResponseEnvelopeCollectionEventsResponseTypedDict,
)
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from censys_platform.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3CollectionsListEventsGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3CollectionsListEventsGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class ChangeTypes(str, Enum):
    ASSET = "asset"
    STATUS = "status"


class AssetChangeTypes(str, Enum):
    ADDED = "added"
    REMOVED = "removed"


class StatusChangeTypes(str, Enum):
    ACTIVE = "active"
    ARCHIVED = "archived"
    PAUSED = "paused"
    POPULATING = "populating"


class V3CollectionsListEventsRequestTypedDict(TypedDict):
    collection_uid: str
    r"""The UID for the collection. Obtain the collection ID using the [list collections endpoint](https://docs.censys.com/reference/v3-collections-crud-list#/) or via the collection URL when using the web console."""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""
    page_size: NotRequired[int]
    r"""Amount of results to return per page."""
    page_token: NotRequired[str]
    r"""Page token for the requested page of collection results."""
    change_types: NotRequired[Nullable[List[ChangeTypes]]]
    r"""Change types"""
    asset_change_types: NotRequired[Nullable[List[AssetChangeTypes]]]
    r"""Asset change types"""
    status_change_types: NotRequired[Nullable[List[StatusChangeTypes]]]
    r"""Status change types"""
    start_time: NotRequired[datetime]
    r"""Start time of the host timeline"""
    end_time: NotRequired[datetime]
    r"""End time of the host timeline"""


class V3CollectionsListEventsRequest(BaseModel):
    collection_uid: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The UID for the collection. Obtain the collection ID using the [list collections endpoint](https://docs.censys.com/reference/v3-collections-crud-list#/) or via the collection URL when using the web console."""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""

    page_size: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Amount of results to return per page."""

    page_token: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Page token for the requested page of collection results."""

    change_types: Annotated[
        OptionalNullable[List[ChangeTypes]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = UNSET
    r"""Change types"""

    asset_change_types: Annotated[
        OptionalNullable[List[AssetChangeTypes]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = UNSET
    r"""Asset change types"""

    status_change_types: Annotated[
        OptionalNullable[List[StatusChangeTypes]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = UNSET
    r"""Status change types"""

    start_time: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Start time of the host timeline"""

    end_time: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""End time of the host timeline"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "page_size",
            "page_token",
            "change_types",
            "asset_change_types",
            "status_change_types",
            "start_time",
            "end_time",
        ]
        nullable_fields = ["change_types", "asset_change_types", "status_change_types"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class V3CollectionsListEventsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeCollectionEventsResponseTypedDict


class V3CollectionsListEventsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeCollectionEventsResponse
