"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .crudupdateinputbody import CrudUpdateInputBody, CrudUpdateInputBodyTypedDict
from .responseenvelopecollection import (
    ResponseEnvelopeCollection,
    ResponseEnvelopeCollectionTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3CollectionsCrudUpdateGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3CollectionsCrudUpdateGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3CollectionsCrudUpdateRequestTypedDict(TypedDict):
    collection_uid: str
    r"""The UID for the collection"""
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""
    crud_update_input_body: NotRequired[CrudUpdateInputBodyTypedDict]


class V3CollectionsCrudUpdateRequest(BaseModel):
    collection_uid: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The UID for the collection"""

    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""

    crud_update_input_body: Annotated[
        Optional[CrudUpdateInputBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class V3CollectionsCrudUpdateResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeCollectionTypedDict


class V3CollectionsCrudUpdateResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeCollection
