"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .crudcreateinputbody import CrudCreateInputBody, CrudCreateInputBodyTypedDict
from .responseenvelopecollection import (
    ResponseEnvelopeCollection,
    ResponseEnvelopeCollectionTypedDict,
)
from censys_platform.types import BaseModel
from censys_platform.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3CollectionsCrudCreateGlobalsTypedDict(TypedDict):
    organization_id: NotRequired[str]


class V3CollectionsCrudCreateGlobals(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None


class V3CollectionsCrudCreateRequestTypedDict(TypedDict):
    organization_id: NotRequired[str]
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""
    crud_create_input_body: NotRequired[CrudCreateInputBodyTypedDict]


class V3CollectionsCrudCreateRequest(BaseModel):
    organization_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information."""

    crud_create_input_body: Annotated[
        Optional[CrudCreateInputBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class V3CollectionsCrudCreateResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ResponseEnvelopeCollectionTypedDict


class V3CollectionsCrudCreateResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ResponseEnvelopeCollection
