"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .upnp_service import UpnpService, UpnpServiceTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class UpnpDeviceTypedDict(TypedDict):
    device_type: NotRequired[str]
    friendly_name: NotRequired[str]
    id: NotRequired[int]
    r"""Censys-generated IDs representing a device tree"""
    manufacturer: NotRequired[str]
    manufacturer_url: NotRequired[str]
    model_description: NotRequired[str]
    model_name: NotRequired[str]
    model_number: NotRequired[str]
    model_url: NotRequired[str]
    parent_id: NotRequired[int]
    presentation_url: NotRequired[str]
    serial_number: NotRequired[str]
    service_list: NotRequired[Nullable[List[UpnpServiceTypedDict]]]
    udn: NotRequired[str]
    upc: NotRequired[str]


class UpnpDevice(BaseModel):
    device_type: Optional[str] = None

    friendly_name: Optional[str] = None

    id: Optional[int] = None
    r"""Censys-generated IDs representing a device tree"""

    manufacturer: Optional[str] = None

    manufacturer_url: Optional[str] = None

    model_description: Optional[str] = None

    model_name: Optional[str] = None

    model_number: Optional[str] = None

    model_url: Optional[str] = None

    parent_id: Optional[int] = None

    presentation_url: Optional[str] = None

    serial_number: Optional[str] = None

    service_list: OptionalNullable[List[UpnpService]] = UNSET

    udn: Optional[str] = None

    upc: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "device_type",
            "friendly_name",
            "id",
            "manufacturer",
            "manufacturer_url",
            "model_description",
            "model_name",
            "model_number",
            "model_url",
            "parent_id",
            "presentation_url",
            "serial_number",
            "service_list",
            "udn",
            "upc",
        ]
        nullable_fields = ["service_list"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
