"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .tls_chain import TLSChain, TLSChainTypedDict
from .tls_versiondata import TLSVersionData, TLSVersionDataTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class VersionSelected(str, Enum):
    r"""Certificate version v1(0), v2(1), v3(2)."""

    UNKNOWN = ""
    SS_LV_2 = "ss_lv_2"
    SS_LV_3 = "ss_lv_3"
    TLSV1_0 = "tlsv1_0"
    TLSV1_1 = "tlsv1_1"
    TLSV1_2 = "tlsv1_2"
    TLSV1_3 = "tlsv1_3"
    DTLSV1_0 = "dtlsv1_0"
    DTLSV1_2 = "dtlsv1_2"
    DTLSV1_3 = "dtlsv1_3"


class TLSTypedDict(TypedDict):
    cipher_selected: NotRequired[str]
    r"""Cipher suite chosen for the exchange."""
    fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records."""
    ja3s: NotRequired[str]
    r"""The JA3S fingerprint for this service."""
    ja4s: NotRequired[str]
    presented_chain: NotRequired[Nullable[List[TLSChainTypedDict]]]
    r"""Certificate chain information."""
    version_selected: NotRequired[VersionSelected]
    r"""Certificate version v1(0), v2(1), v3(2)."""
    versions: NotRequired[Nullable[List[TLSVersionDataTypedDict]]]


class TLS(BaseModel):
    cipher_selected: Optional[str] = None
    r"""Cipher suite chosen for the exchange."""

    fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records."""

    ja3s: Optional[str] = None
    r"""The JA3S fingerprint for this service."""

    ja4s: Optional[str] = None

    presented_chain: OptionalNullable[List[TLSChain]] = UNSET
    r"""Certificate chain information."""

    version_selected: Optional[VersionSelected] = None
    r"""Certificate version v1(0), v2(1), v3(2)."""

    versions: OptionalNullable[List[TLSVersionData]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cipher_selected",
            "fingerprint_sha256",
            "ja3s",
            "ja4s",
            "presented_chain",
            "version_selected",
            "versions",
        ]
        nullable_fields = ["presented_chain", "versions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
