"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .evidence import Evidence, EvidenceTypedDict
from .threat_actor import ThreatActor, ThreatActorTypedDict
from .threat_details import ThreatDetails, ThreatDetailsTypedDict
from .threat_malware import ThreatMalware, ThreatMalwareTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ThreatSource(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    RECOG = "recog"
    WAPPALYZER = "wappalyzer"
    THIRD_PARTY = "third_party"


class ThreatTypedDict(TypedDict):
    actors: NotRequired[Nullable[List[ThreatActorTypedDict]]]
    confidence: NotRequired[float]
    details: NotRequired[ThreatDetailsTypedDict]
    evidence: NotRequired[Nullable[List[EvidenceTypedDict]]]
    id: NotRequired[str]
    malware: NotRequired[ThreatMalwareTypedDict]
    name: NotRequired[str]
    source: NotRequired[ThreatSource]
    tactic: NotRequired[Nullable[List[str]]]
    type: NotRequired[Nullable[List[str]]]


class Threat(BaseModel):
    actors: OptionalNullable[List[ThreatActor]] = UNSET

    confidence: Optional[float] = None

    details: Optional[ThreatDetails] = None

    evidence: OptionalNullable[List[Evidence]] = UNSET

    id: Optional[str] = None

    malware: Optional[ThreatMalware] = None

    name: Optional[str] = None

    source: Optional[ThreatSource] = None

    tactic: OptionalNullable[List[str]] = UNSET

    type: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "actors",
            "confidence",
            "details",
            "evidence",
            "id",
            "malware",
            "name",
            "source",
            "tactic",
            "type",
        ]
        nullable_fields = ["actors", "evidence", "tactic", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
