"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .user import User, UserTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SteamTypedDict(TypedDict):
    broadcasting_active: NotRequired[bool]
    connect_port: NotRequired[int]
    content_cache_port: NotRequired[int]
    download_lan_peer_group: NotRequired[int]
    enabled_services: NotRequired[int]
    euniverse: NotRequired[int]
    games_running: NotRequired[bool]
    hostname: NotRequired[str]
    ip_addresses: NotRequired[Nullable[List[str]]]
    is64bit: NotRequired[bool]
    mac_addresses: NotRequired[Nullable[List[str]]]
    min_version: NotRequired[int]
    ostype: NotRequired[int]
    public_ip_address: NotRequired[str]
    remoteplay_active: NotRequired[bool]
    screen_locked: NotRequired[bool]
    steam_deck: NotRequired[bool]
    steam_version: NotRequired[str]
    supported_services: NotRequired[int]
    users: NotRequired[Nullable[List[UserTypedDict]]]
    version: NotRequired[int]
    vr_active: NotRequired[bool]
    vr_link_caps: NotRequired[str]


class Steam(BaseModel):
    broadcasting_active: Optional[bool] = None

    connect_port: Optional[int] = None

    content_cache_port: Optional[int] = None

    download_lan_peer_group: Optional[int] = None

    enabled_services: Optional[int] = None

    euniverse: Optional[int] = None

    games_running: Optional[bool] = None

    hostname: Optional[str] = None

    ip_addresses: OptionalNullable[List[str]] = UNSET

    is64bit: Optional[bool] = None

    mac_addresses: OptionalNullable[List[str]] = UNSET

    min_version: Optional[int] = None

    ostype: Optional[int] = None

    public_ip_address: Optional[str] = None

    remoteplay_active: Optional[bool] = None

    screen_locked: Optional[bool] = None

    steam_deck: Optional[bool] = None

    steam_version: Optional[str] = None

    supported_services: Optional[int] = None

    users: OptionalNullable[List[User]] = UNSET

    version: Optional[int] = None

    vr_active: Optional[bool] = None

    vr_link_caps: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "broadcasting_active",
            "connect_port",
            "content_cache_port",
            "download_lan_peer_group",
            "enabled_services",
            "euniverse",
            "games_running",
            "hostname",
            "ip_addresses",
            "is64bit",
            "mac_addresses",
            "min_version",
            "ostype",
            "public_ip_address",
            "remoteplay_active",
            "screen_locked",
            "steam_deck",
            "steam_version",
            "supported_services",
            "users",
            "version",
            "vr_active",
            "vr_link_caps",
        ]
        nullable_fields = ["ip_addresses", "mac_addresses", "users"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
