"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SSHKexInitMessageTypedDict(TypedDict):
    client_to_server_ciphers: NotRequired[Nullable[List[str]]]
    r"""A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values."""
    client_to_server_compression: NotRequired[Nullable[List[str]]]
    r"""A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values."""
    client_to_server_languages: NotRequired[Nullable[List[str]]]
    r"""A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt."""
    client_to_server_macs: NotRequired[Nullable[List[str]]]
    r"""A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values."""
    first_kex_follows: NotRequired[bool]
    host_key_algorithms: NotRequired[Nullable[List[str]]]
    r"""Asymmetric key algorithms for the host key supported by the client."""
    kex_algorithms: NotRequired[Nullable[List[str]]]
    r"""Key exchange algorithms used in the handshake."""
    server_to_client_ciphers: NotRequired[Nullable[List[str]]]
    r"""A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values."""
    server_to_client_compression: NotRequired[Nullable[List[str]]]
    r"""A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values."""
    server_to_client_languages: NotRequired[Nullable[List[str]]]
    r"""A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt."""
    server_to_client_macs: NotRequired[Nullable[List[str]]]
    r"""A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values."""


class SSHKexInitMessage(BaseModel):
    client_to_server_ciphers: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values."""

    client_to_server_compression: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values."""

    client_to_server_languages: OptionalNullable[List[str]] = UNSET
    r"""A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt."""

    client_to_server_macs: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values."""

    first_kex_follows: Optional[bool] = None

    host_key_algorithms: OptionalNullable[List[str]] = UNSET
    r"""Asymmetric key algorithms for the host key supported by the client."""

    kex_algorithms: OptionalNullable[List[str]] = UNSET
    r"""Key exchange algorithms used in the handshake."""

    server_to_client_ciphers: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values."""

    server_to_client_compression: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values."""

    server_to_client_languages: OptionalNullable[List[str]] = UNSET
    r"""A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt."""

    server_to_client_macs: OptionalNullable[List[str]] = UNSET
    r"""A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "client_to_server_ciphers",
            "client_to_server_compression",
            "client_to_server_languages",
            "client_to_server_macs",
            "first_kex_follows",
            "host_key_algorithms",
            "kex_algorithms",
            "server_to_client_ciphers",
            "server_to_client_compression",
            "server_to_client_languages",
            "server_to_client_macs",
        ]
        nullable_fields = [
            "client_to_server_ciphers",
            "client_to_server_compression",
            "client_to_server_languages",
            "client_to_server_macs",
            "host_key_algorithms",
            "kex_algorithms",
            "server_to_client_ciphers",
            "server_to_client_compression",
            "server_to_client_languages",
            "server_to_client_macs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
