"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SearchQueryInputBodyTypedDict(TypedDict):
    query: str
    r"""CenQL query string to search upon"""
    fields: NotRequired[Nullable[List[str]]]
    r"""specify fields to return in response and ignore others"""
    page_size: NotRequired[Nullable[int]]
    r"""amount of results to return per page"""
    page_token: NotRequired[str]
    r"""page token for the requested page of search results"""


class SearchQueryInputBody(BaseModel):
    query: str
    r"""CenQL query string to search upon"""

    fields: OptionalNullable[List[str]] = UNSET
    r"""specify fields to return in response and ignore others"""

    page_size: OptionalNullable[int] = UNSET
    r"""amount of results to return per page"""

    page_token: Optional[str] = None
    r"""page token for the requested page of search results"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["fields", "page_size", "page_token"]
        nullable_fields = ["fields", "page_size"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
