"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .saprouter_clientinfo import SapRouterClientInfo, SapRouterClientInfoTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SapRouterRouterInfoTypedDict(TypedDict):
    connected_client_info: NotRequired[Nullable[List[SapRouterClientInfoTypedDict]]]
    num_clients: NotRequired[int]
    parent_pid: NotRequired[int]
    parent_port: NotRequired[int]
    pid: NotRequired[int]
    port: NotRequired[int]
    routtab_relative_directory: NotRequired[str]
    sap_router_absolute_directory: NotRequired[str]
    started_on: NotRequired[str]


class SapRouterRouterInfo(BaseModel):
    connected_client_info: OptionalNullable[List[SapRouterClientInfo]] = UNSET

    num_clients: Optional[int] = None

    parent_pid: Optional[int] = None

    parent_port: Optional[int] = None

    pid: Optional[int] = None

    port: Optional[int] = None

    routtab_relative_directory: Optional[str] = None

    sap_router_absolute_directory: Optional[str] = None

    started_on: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "connected_client_info",
            "num_clients",
            "parent_pid",
            "parent_port",
            "pid",
            "port",
            "routtab_relative_directory",
            "sap_router_absolute_directory",
            "started_on",
        ]
        nullable_fields = ["connected_client_info"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
