"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .rootstore_chain import RootStoreChain, RootStoreChainTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Type(str, Enum):
    r"""The certificate's type. Options include root, intermediate, or leaf."""

    UNKNOWN = ""
    ROOT = "root"
    INTERMEDIATE = "intermediate"
    LEAF = "leaf"


class RootStoreTypedDict(TypedDict):
    chains: NotRequired[Nullable[List[RootStoreChainTypedDict]]]
    r"""A path of trusted signing certificates up to a root certificate present in a root store, represented as an ordered list of SHA-256 fingerprints."""
    ever_valid: NotRequired[bool]
    r"""Whether the certificate has ever been considered valid by the root store."""
    had_trusted_path: NotRequired[bool]
    r"""Whether there ever existed a trusted path of signing certificates from a certificate present in the root certificate store."""
    has_trusted_path: NotRequired[bool]
    r"""Whether there currently exists a trusted path of signing certificates from a certificate present in the root certificate store."""
    in_revocation_set: NotRequired[bool]
    r"""Whether the certificate is in the revocation set (e.g. OneCRL) associated with the root store."""
    is_valid: NotRequired[bool]
    r"""Whether the certificate is currently considered valid by the root store: a summary of the trust path, revoked, blocklisted/allowlisted, and expired fields."""
    parents: NotRequired[Nullable[List[str]]]
    r"""The SHA-256 fingerprints of the certificate's immediate parents in its trust path(s)."""
    type: NotRequired[Type]
    r"""The certificate's type. Options include root, intermediate, or leaf."""


class RootStore(BaseModel):
    chains: OptionalNullable[List[RootStoreChain]] = UNSET
    r"""A path of trusted signing certificates up to a root certificate present in a root store, represented as an ordered list of SHA-256 fingerprints."""

    ever_valid: Optional[bool] = None
    r"""Whether the certificate has ever been considered valid by the root store."""

    had_trusted_path: Optional[bool] = None
    r"""Whether there ever existed a trusted path of signing certificates from a certificate present in the root certificate store."""

    has_trusted_path: Optional[bool] = None
    r"""Whether there currently exists a trusted path of signing certificates from a certificate present in the root certificate store."""

    in_revocation_set: Optional[bool] = None
    r"""Whether the certificate is in the revocation set (e.g. OneCRL) associated with the root store."""

    is_valid: Optional[bool] = None
    r"""Whether the certificate is currently considered valid by the root store: a summary of the trust path, revoked, blocklisted/allowlisted, and expired fields."""

    parents: OptionalNullable[List[str]] = UNSET
    r"""The SHA-256 fingerprints of the certificate's immediate parents in its trust path(s)."""

    type: Optional[Type] = None
    r"""The certificate's type. Options include root, intermediate, or leaf."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "chains",
            "ever_valid",
            "had_trusted_path",
            "has_trusted_path",
            "in_revocation_set",
            "is_valid",
            "parents",
            "type",
        ]
        nullable_fields = ["chains", "parents"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
