"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cvss import Cvss, CvssTypedDict
from .evidence import Evidence, EvidenceTypedDict
from .metrics import Metrics, MetricsTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RiskSource(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    CVE = "cve"


class Severity(str, Enum):
    UNKNOWN = ""
    LOW = "low"
    MEDIUM = "medium"
    HIGH = "high"
    CRITICAL = "critical"


class RiskSource1(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    RECOG = "recog"
    WAPPALYZER = "wappalyzer"
    THIRD_PARTY = "third_party"


class RiskTypedDict(TypedDict):
    confidence: NotRequired[float]
    cvss: NotRequired[CvssTypedDict]
    evidence: NotRequired[Nullable[List[EvidenceTypedDict]]]
    id: NotRequired[str]
    metrics: NotRequired[MetricsTypedDict]
    name: NotRequired[str]
    risk_source: NotRequired[RiskSource]
    severity: NotRequired[Severity]
    source: NotRequired[RiskSource1]
    year: NotRequired[int]


class Risk(BaseModel):
    confidence: Optional[float] = None

    cvss: Optional[Cvss] = None

    evidence: OptionalNullable[List[Evidence]] = UNSET

    id: Optional[str] = None

    metrics: Optional[Metrics] = None

    name: Optional[str] = None

    risk_source: Optional[RiskSource] = None

    severity: Optional[Severity] = None

    source: Optional[RiskSource1] = None

    year: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "confidence",
            "cvss",
            "evidence",
            "id",
            "metrics",
            "name",
            "risk_source",
            "severity",
            "source",
            "year",
        ]
        nullable_fields = ["evidence"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
