"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .peer import Peer, PeerTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RipplePeerResultsTypedDict(TypedDict):
    build_version: NotRequired[str]
    peer_crawler_response_version: NotRequired[int]
    peers: NotRequired[Nullable[List[PeerTypedDict]]]
    pubkey_node: NotRequired[str]
    publisher_list: NotRequired[Nullable[List[str]]]
    server_state: NotRequired[str]
    validator_sites: NotRequired[Nullable[List[str]]]


class RipplePeerResults(BaseModel):
    build_version: Optional[str] = None

    peer_crawler_response_version: Optional[int] = None

    peers: OptionalNullable[List[Peer]] = UNSET

    pubkey_node: Optional[str] = None

    publisher_list: OptionalNullable[List[str]] = UNSET

    server_state: Optional[str] = None

    validator_sites: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "build_version",
            "peer_crawler_response_version",
            "peers",
            "pubkey_node",
            "publisher_list",
            "server_state",
            "validator_sites",
        ]
        nullable_fields = ["peers", "publisher_list", "validator_sites"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
