"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .port import Port, PortTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RippledPublicResultsTypedDict(TypedDict):
    build_version: NotRequired[str]
    hostid: NotRequired[str]
    network_id: NotRequired[int]
    peers: NotRequired[int]
    ports: NotRequired[Nullable[List[PortTypedDict]]]
    pubkey_node: NotRequired[str]
    server_state: NotRequired[str]
    validation_quorum: NotRequired[int]


class RippledPublicResults(BaseModel):
    build_version: Optional[str] = None

    hostid: Optional[str] = None

    network_id: Optional[int] = None

    peers: Optional[int] = None

    ports: OptionalNullable[List[Port]] = UNSET

    pubkey_node: Optional[str] = None

    server_state: Optional[str] = None

    validation_quorum: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "build_version",
            "hostid",
            "network_id",
            "peers",
            "ports",
            "pubkey_node",
            "server_state",
            "validation_quorum",
        ]
        nullable_fields = ["ports"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
