"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RepresentativeInfoReason(str, Enum):
    UNKNOWN = ""
    PROTOCOL_PORT_COUNT = "protocol_port_count"
    INCAPSULA = "incapsula"
    ZSCALER = "zscaler"


class RepresentativeInfoTypedDict(TypedDict):
    excluded_ports: NotRequired[Nullable[List[int]]]
    reason: NotRequired[RepresentativeInfoReason]
    represented_ports: NotRequired[Nullable[List[int]]]
    sampled_port: NotRequired[int]


class RepresentativeInfo(BaseModel):
    excluded_ports: OptionalNullable[List[int]] = UNSET

    reason: Optional[RepresentativeInfoReason] = None

    represented_ports: OptionalNullable[List[int]] = UNSET

    sampled_port: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "excluded_ports",
            "reason",
            "represented_ports",
            "sampled_port",
        ]
        nullable_fields = ["excluded_ports", "represented_ports"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
