"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .redis_rawoutput import RedisRawOutput, RedisRawOutputTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class RedisTypedDict(TypedDict):
    arch_bits: NotRequired[str]
    r"""The architecture bits (32 or 64) the Redis server used to build."""
    auth_response: NotRequired[str]
    r"""The response from the AUTH command, if sent."""
    build_id: NotRequired[str]
    r"""The Build ID of the Redis server."""
    commands: NotRequired[Nullable[List[str]]]
    r"""The list of commands actually sent to the server, serialized in inline format, like 'PING' or 'AUTH somePassword'."""
    commands_processed: NotRequired[int]
    r"""The total number of commands processed by the server."""
    connections_received: NotRequired[int]
    r"""The total number of connections accepted by the server."""
    gcc_version: NotRequired[str]
    r"""The version of the GCC compiler used to compile the Redis server."""
    git_sha1: NotRequired[str]
    r"""The Sha-1 Git commit hash the Redis server used."""
    info_response: NotRequired[Dict[str, str]]
    r"""The response from the INFO command. Should be a series of key:value pairs separated by CRLFs."""
    major: NotRequired[int]
    r"""Major is the version's major number."""
    mem_allocator: NotRequired[str]
    r"""The memory allocator."""
    minor: NotRequired[int]
    r"""Minor is the version's major number."""
    mode: NotRequired[str]
    r"""The mode the Redis server is running (standalone or cluster), read from the the info_response (if available)."""
    nonexistent_response: NotRequired[str]
    r"""The response from the NONEXISTENT command."""
    os: NotRequired[str]
    r"""The OS the Redis server is running, read from the the info_response (if available)."""
    patch_level: NotRequired[int]
    r"""Patchlevel is the version's patchlevel number."""
    ping_response: NotRequired[str]
    r"""The response from the PING command; should either be \"PONG\" or an authentication error."""
    quit_response: NotRequired[str]
    r"""The response to the QUIT command."""
    raw_command_output: NotRequired[Nullable[List[RedisRawOutputTypedDict]]]
    r"""The raw output returned by the server for each command sent; the indices match those of commands."""
    uptime: NotRequired[int]
    r"""The number of seconds since Redis server start."""
    used_memory: NotRequired[int]
    r"""The total number of bytes allocated by Redis using its allocator."""


class Redis(BaseModel):
    arch_bits: Optional[str] = None
    r"""The architecture bits (32 or 64) the Redis server used to build."""

    auth_response: Optional[str] = None
    r"""The response from the AUTH command, if sent."""

    build_id: Optional[str] = None
    r"""The Build ID of the Redis server."""

    commands: OptionalNullable[List[str]] = UNSET
    r"""The list of commands actually sent to the server, serialized in inline format, like 'PING' or 'AUTH somePassword'."""

    commands_processed: Optional[int] = None
    r"""The total number of commands processed by the server."""

    connections_received: Optional[int] = None
    r"""The total number of connections accepted by the server."""

    gcc_version: Optional[str] = None
    r"""The version of the GCC compiler used to compile the Redis server."""

    git_sha1: Optional[str] = None
    r"""The Sha-1 Git commit hash the Redis server used."""

    info_response: Optional[Dict[str, str]] = None
    r"""The response from the INFO command. Should be a series of key:value pairs separated by CRLFs."""

    major: Optional[int] = None
    r"""Major is the version's major number."""

    mem_allocator: Optional[str] = None
    r"""The memory allocator."""

    minor: Optional[int] = None
    r"""Minor is the version's major number."""

    mode: Optional[str] = None
    r"""The mode the Redis server is running (standalone or cluster), read from the the info_response (if available)."""

    nonexistent_response: Optional[str] = None
    r"""The response from the NONEXISTENT command."""

    os: Optional[str] = None
    r"""The OS the Redis server is running, read from the the info_response (if available)."""

    patch_level: Optional[int] = None
    r"""Patchlevel is the version's patchlevel number."""

    ping_response: Optional[str] = None
    r"""The response from the PING command; should either be \"PONG\" or an authentication error."""

    quit_response: Optional[str] = None
    r"""The response to the QUIT command."""

    raw_command_output: OptionalNullable[List[RedisRawOutput]] = UNSET
    r"""The raw output returned by the server for each command sent; the indices match those of commands."""

    uptime: Optional[int] = None
    r"""The number of seconds since Redis server start."""

    used_memory: Optional[int] = None
    r"""The total number of bytes allocated by Redis using its allocator."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "arch_bits",
            "auth_response",
            "build_id",
            "commands",
            "commands_processed",
            "connections_received",
            "gcc_version",
            "git_sha1",
            "info_response",
            "major",
            "mem_allocator",
            "minor",
            "mode",
            "nonexistent_response",
            "os",
            "patch_level",
            "ping_response",
            "quit_response",
            "raw_command_output",
            "uptime",
            "used_memory",
        ]
        nullable_fields = ["commands", "raw_command_output"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
