"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .prometheus_response_activetarget import (
    PrometheusResponseActiveTarget,
    PrometheusResponseActiveTargetTypedDict,
)
from .prometheus_response_droppedtarget import (
    PrometheusResponseDroppedTarget,
    PrometheusResponseDroppedTargetTypedDict,
)
from .prometheus_response_prometheusversion import (
    PrometheusResponsePrometheusVersion,
    PrometheusResponsePrometheusVersionTypedDict,
)
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class PrometheusResponseTypedDict(TypedDict):
    active_targets: NotRequired[Nullable[List[PrometheusResponseActiveTargetTypedDict]]]
    r"""List of active targets."""
    all_versions: NotRequired[Nullable[List[str]]]
    r"""List of the versions of everything that Prometheus finds i.e., version of Prometheus, Go, Node, cAdvisor, etc."""
    config_exposed: NotRequired[bool]
    r"""True when the config endpoint is exposed."""
    dropped_targets: NotRequired[
        Nullable[List[PrometheusResponseDroppedTargetTypedDict]]
    ]
    r"""List of dropped targets."""
    go_versions: NotRequired[Nullable[List[str]]]
    r"""List of the versions of Go."""
    prometheus_versions: NotRequired[
        Nullable[List[PrometheusResponsePrometheusVersionTypedDict]]
    ]


class PrometheusResponse(BaseModel):
    active_targets: OptionalNullable[List[PrometheusResponseActiveTarget]] = UNSET
    r"""List of active targets."""

    all_versions: OptionalNullable[List[str]] = UNSET
    r"""List of the versions of everything that Prometheus finds i.e., version of Prometheus, Go, Node, cAdvisor, etc."""

    config_exposed: Optional[bool] = None
    r"""True when the config endpoint is exposed."""

    dropped_targets: OptionalNullable[List[PrometheusResponseDroppedTarget]] = UNSET
    r"""List of dropped targets."""

    go_versions: OptionalNullable[List[str]] = UNSET
    r"""List of the versions of Go."""

    prometheus_versions: OptionalNullable[List[PrometheusResponsePrometheusVersion]] = (
        UNSET
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "active_targets",
            "all_versions",
            "config_exposed",
            "dropped_targets",
            "go_versions",
            "prometheus_versions",
        ]
        nullable_fields = [
            "active_targets",
            "all_versions",
            "dropped_targets",
            "go_versions",
            "prometheus_versions",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
