"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class PixelFormatTypedDict(TypedDict):
    big_endian: NotRequired[bool]
    r"""If pixel RGB data are in big-endian"""
    bits_per_pixel: NotRequired[int]
    r"""How many bits in a single full pixel datum. Valid values are: 8, 16, 32"""
    blue_max: NotRequired[int]
    r"""Max value of blue pixel"""
    blue_shift: NotRequired[int]
    r"""How many bits to right shift a pixel datum to get blue bits in lsb"""
    depth: NotRequired[int]
    r"""Color depth"""
    green_max: NotRequired[int]
    r"""Max value of green pixel"""
    green_shift: NotRequired[int]
    r"""How many bits to right shift a pixel datum to get green bits in lsb"""
    padding1: NotRequired[int]
    padding2: NotRequired[int]
    padding3: NotRequired[int]
    red_max: NotRequired[int]
    r"""Max value of red pixel"""
    red_shift: NotRequired[int]
    r"""How many bits to right shift a pixel datum to get red bits in lsb"""
    true_color: NotRequired[bool]
    r"""If false, color maps are used"""


class PixelFormat(BaseModel):
    big_endian: Optional[bool] = None
    r"""If pixel RGB data are in big-endian"""

    bits_per_pixel: Optional[int] = None
    r"""How many bits in a single full pixel datum. Valid values are: 8, 16, 32"""

    blue_max: Optional[int] = None
    r"""Max value of blue pixel"""

    blue_shift: Optional[int] = None
    r"""How many bits to right shift a pixel datum to get blue bits in lsb"""

    depth: Optional[int] = None
    r"""Color depth"""

    green_max: Optional[int] = None
    r"""Max value of green pixel"""

    green_shift: Optional[int] = None
    r"""How many bits to right shift a pixel datum to get green bits in lsb"""

    padding1: Optional[int] = None

    padding2: Optional[int] = None

    padding3: Optional[int] = None

    red_max: Optional[int] = None
    r"""Max value of red pixel"""

    red_shift: Optional[int] = None
    r"""How many bits to right shift a pixel datum to get red bits in lsb"""

    true_color: Optional[bool] = None
    r"""If false, color maps are used"""
