"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .contact import Contact, ContactTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class OrganizationTypedDict(TypedDict):
    abuse_contacts: NotRequired[Nullable[List[ContactTypedDict]]]
    address: NotRequired[str]
    admin_contacts: NotRequired[Nullable[List[ContactTypedDict]]]
    city: NotRequired[str]
    country: NotRequired[str]
    handle: NotRequired[str]
    name: NotRequired[str]
    postal_code: NotRequired[str]
    state: NotRequired[str]
    street: NotRequired[str]
    tech_contacts: NotRequired[Nullable[List[ContactTypedDict]]]


class Organization(BaseModel):
    abuse_contacts: OptionalNullable[List[Contact]] = UNSET

    address: Optional[str] = None

    admin_contacts: OptionalNullable[List[Contact]] = UNSET

    city: Optional[str] = None

    country: Optional[str] = None

    handle: Optional[str] = None

    name: Optional[str] = None

    postal_code: Optional[str] = None

    state: Optional[str] = None

    street: Optional[str] = None

    tech_contacts: OptionalNullable[List[Contact]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "abuse_contacts",
            "address",
            "admin_contacts",
            "city",
            "country",
            "handle",
            "name",
            "postal_code",
            "state",
            "street",
            "tech_contacts",
        ]
        nullable_fields = ["abuse_contacts", "admin_contacts", "tech_contacts"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
