"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .oracle_descriptor import OracleDescriptor, OracleDescriptorTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class OracleTypedDict(TypedDict):
    accept_version: NotRequired[int]
    r"""The version declared by the service when it accepts the handshake, if applicable."""
    connect_flags0: NotRequired[Dict[str, bool]]
    r"""The first set of ConnectFlags returned in the Accept packet."""
    connect_flags1: NotRequired[Dict[str, bool]]
    r"""The second set of ConnectFlags returned in the Accept packet."""
    did_resend: NotRequired[bool]
    r"""Whether the server requested that the scanner resend its initial connection packet."""
    global_service_options: NotRequired[Dict[str, bool]]
    r"""Set of flags that the server returns in the Accept packet."""
    nsn_service_versions: NotRequired[Dict[str, str]]
    r"""A map from the native Service Negotation service names to the ReleaseVersion (in dotted-decimal format) in that service packet."""
    nsn_version: NotRequired[str]
    r"""The version string in the root of the native service negotiation packet, if applicable."""
    refuse_error: NotRequired[Nullable[List[OracleDescriptorTypedDict]]]
    r"""The parsed descriptor returned by the server in the Refuse packet; it is empty if the server does not return a Refuse packet. The keys are strings like 'DESCRIPTION.ERROR_STACK.ERROR.CODE"""
    refuse_error_raw: NotRequired[str]
    r"""The unparsed error received when the initial handshake is refused."""
    refuse_reason_app: NotRequired[str]
    r"""The 'AppReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string."""
    refuse_reason_sys: NotRequired[str]
    r"""The 'SysReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string."""
    refuse_version: NotRequired[str]
    r"""The version declared by the service when it refuses the handshake, if applicable."""


class Oracle(BaseModel):
    accept_version: Optional[int] = None
    r"""The version declared by the service when it accepts the handshake, if applicable."""

    connect_flags0: Optional[Dict[str, bool]] = None
    r"""The first set of ConnectFlags returned in the Accept packet."""

    connect_flags1: Optional[Dict[str, bool]] = None
    r"""The second set of ConnectFlags returned in the Accept packet."""

    did_resend: Optional[bool] = None
    r"""Whether the server requested that the scanner resend its initial connection packet."""

    global_service_options: Optional[Dict[str, bool]] = None
    r"""Set of flags that the server returns in the Accept packet."""

    nsn_service_versions: Optional[Dict[str, str]] = None
    r"""A map from the native Service Negotation service names to the ReleaseVersion (in dotted-decimal format) in that service packet."""

    nsn_version: Optional[str] = None
    r"""The version string in the root of the native service negotiation packet, if applicable."""

    refuse_error: OptionalNullable[List[OracleDescriptor]] = UNSET
    r"""The parsed descriptor returned by the server in the Refuse packet; it is empty if the server does not return a Refuse packet. The keys are strings like 'DESCRIPTION.ERROR_STACK.ERROR.CODE"""

    refuse_error_raw: Optional[str] = None
    r"""The unparsed error received when the initial handshake is refused."""

    refuse_reason_app: Optional[str] = None
    r"""The 'AppReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string."""

    refuse_reason_sys: Optional[str] = None
    r"""The 'SysReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string."""

    refuse_version: Optional[str] = None
    r"""The version declared by the service when it refuses the handshake, if applicable."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accept_version",
            "connect_flags0",
            "connect_flags1",
            "did_resend",
            "global_service_options",
            "nsn_service_versions",
            "nsn_version",
            "refuse_error",
            "refuse_error_raw",
            "refuse_reason_app",
            "refuse_reason_sys",
            "refuse_version",
        ]
        nullable_fields = ["refuse_error"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
