"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .opcua_localizedtext import OpcUaLocalizedText, OpcUaLocalizedTextTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class OpcUaDescriptionTypedDict(TypedDict):
    application_name: NotRequired[OpcUaLocalizedTextTypedDict]
    application_type: NotRequired[int]
    application_uri: NotRequired[str]
    discovery_profile_uri: NotRequired[str]
    discovery_urls: NotRequired[Nullable[List[str]]]
    gateway_server_uri: NotRequired[str]
    product_uri: NotRequired[str]


class OpcUaDescription(BaseModel):
    application_name: Optional[OpcUaLocalizedText] = None

    application_type: Optional[int] = None

    application_uri: Optional[str] = None

    discovery_profile_uri: Optional[str] = None

    discovery_urls: OptionalNullable[List[str]] = UNSET

    gateway_server_uri: Optional[str] = None

    product_uri: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "application_name",
            "application_type",
            "application_uri",
            "discovery_profile_uri",
            "discovery_urls",
            "gateway_server_uri",
            "product_uri",
        ]
        nullable_fields = ["discovery_urls"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
