"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .opcua_endpoint import OpcUaEndpoint, OpcUaEndpointTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class OpcUaTypedDict(TypedDict):
    endpoints: NotRequired[Nullable[List[OpcUaEndpointTypedDict]]]
    max_chunk_size: NotRequired[int]
    max_message_size: NotRequired[int]
    protocol_version: NotRequired[int]
    receive_buffer_size: NotRequired[int]
    send_buffer_size: NotRequired[int]


class OpcUa(BaseModel):
    endpoints: OptionalNullable[List[OpcUaEndpoint]] = UNSET

    max_chunk_size: Optional[int] = None

    max_message_size: Optional[int] = None

    protocol_version: Optional[int] = None

    receive_buffer_size: Optional[int] = None

    send_buffer_size: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "endpoints",
            "max_chunk_size",
            "max_message_size",
            "protocol_version",
            "receive_buffer_size",
            "send_buffer_size",
        ]
        nullable_fields = ["endpoints"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
